/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.common.util.PIHscUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

class Rio5 {
    static String CEC_CIM_CLASS = "IBMHSC_ComputerSystem";
    static String CREATION_CLASS_NAME = "CreationClassName";
    static Vector inParams;
    static Vector outParams;

    Rio5() {
    }

    static String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    static CIMObjectPath getCOP(String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(CEC_CIM_CLASS, "root/ibmhscS1_0");
        cIMObjectPath.addKey("Name", new CIMValue((Object)string));
        cIMObjectPath.addKey(CREATION_CLASS_NAME, new CIMValue((Object)CEC_CIM_CLASS));
        return cIMObjectPath;
    }

    static Vector getIOHubs(String string) {
        Object object;
        Vector vector = new Vector();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
        try {
            object = PIHscUtil.invokeCIMMethod(Rio5.getHostName(), Rio5.getCOP(string), "GetIOHubs", vector, vector2);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetIOHubs method.");
            exception.printStackTrace();
            System.exit(5);
        }
        vector2.add(new CIMProperty("DRCIndex", new CIMValue(new Vector(), new CIMDataType(25))));
        vector2.add(new CIMProperty("HubType", new CIMValue(new Vector(), new CIMDataType(21))));
        object = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
        Vector vector4 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector4.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt32 = null;
        int n = -1;
        int n2 = -1;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration.nextElement();
            unsignedInt32 = (UnsignedInt32)enumeration2.nextElement();
            n = unsignedInt8.intValue();
            n2 = unsignedInt32.intValue();
            if (n == 0) {
                vector3.add(unsignedInt32);
                continue;
            }
            if (n == 1) {
                System.out.println("HubType of Infiniband found on Managed System: " + string);
                System.out.println("Infiniband DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 2) {
                System.out.println("HubType of SMA found on Managed System: " + string);
                System.out.println("SMA DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 255) {
                System.out.println("Error:BED1-0055:Unknown HubType on Managed System:" + string);
                System.exit(10);
                continue;
            }
            System.out.println("Error:BED1-0056:Unable to locate any I/O Hubs this system:" + string);
            System.exit(9);
        }
        return vector3;
    }

    static Vector getRioBuses(UnsignedInt32 unsignedInt32, String string, int n, String string2) {
        Object object;
        Object object2;
        Object object3;
        inParams = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt32, new CIMDataType(5));
        inParams.add(new CIMProperty("HubDRCIndex", cIMValue));
        outParams = new Vector();
        Vector vector = new Vector();
        try {
            object3 = PIHscUtil.invokeCIMMethod(Rio5.getHostName(), Rio5.getCOP(string), "GetRioBuses", inParams, outParams);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetRioBuses method.");
            exception.printStackTrace();
            System.exit(6);
        }
        object3 = (Vector)((CIMProperty)outParams.elementAt(0)).getValue().getValue();
        Vector vector2 = (Vector)((CIMProperty)outParams.elementAt(1)).getValue().getValue();
        Enumeration enumeration = ((Vector)object3).elements();
        Enumeration enumeration2 = vector2.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt322 = null;
        int n2 = -1;
        int n3 = -1;
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration2.nextElement();
            unsignedInt322 = (UnsignedInt32)enumeration.nextElement();
            n2 = unsignedInt8.intValue();
            n3 = unsignedInt322.intValue();
            object2 = unsignedInt322.toString();
            hashtable.put(object2, string2);
            object = hashtable.keys();
        }
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            System.out.print((String)object + "=");
            String string3 = (String)hashtable.get(object);
            Integer n4 = new Integer(string3);
            int n5 = n4;
            String string4 = "";
            string4 = Integer.toHexString(n5);
            System.out.print(string4);
            System.out.println();
        }
        return vector;
    }
}

